//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.6

import wesual.Ui 1.0

Item {
    id : sortOptionBar

    property var options : []

    property int  currentIndex : 0
    property bool bindable     : false

    readonly property var currentOption : options[currentIndex] || null

    signal optionChangeRequested(int index)
    signal sortOrderChangeRequested()

    implicitHeight : 38
    implicitWidth  : items.implicitWidth

    Row {
        id : items

        spacing : 20

        Repeater {
            model : sortOptionBar.options

            delegate : MouseArea {
                height : 38
                width  : label.implicitWidth

                cursorShape : Qt.PointingHandCursor

                onClicked : {
                    if (sortOptionBar.bindable) {
                        if (index === sortOptionBar.currentIndex) {
                            sortOptionBar.sortOrderChangeRequested();
                        } else {
                            sortOptionBar.optionChangeRequested(index);
                        }
                    } else {
                        if (index === sortOptionBar.currentIndex) {
                            if (currentOption) {
                                currentOption.descending =
                                        !currentOption.descending;
                            }
                        } else {
                            sortOptionBar.currentIndex = index;
                        }
                    }
                }

                Image {
                    anchors {
                        bottom       : label.top
                        bottomMargin : 2
                        horizontalCenter : label.horizontalCenter
                    }
                    source   : "qrc:/create/lib/images/sortorder.png"
                    visible  : modelData === currentOption
                    rotation : modelData.descending ? 180 : 0
                    smooth   : false
                }

                UiLabel {
                    id : label

                    text : modelData.label

                    anchors.centerIn : parent
                    anchors.verticalCenterOffset : 3
                }
            }
        }
    }
}
